/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.network;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adhooks.AdHooks;
import com.endertech.minecraft.mods.adhooks.motion.MotionController;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class JumpBoostMsg
extends ForgeNetMsg<JumpBoostMsg> {
    public float maxStrengthFactor = 1.2f;
    public float strength;

    public JumpBoostMsg() {
    }

    public JumpBoostMsg(float strength) {
        this.strength = strength * MotionController.mainFactor;
    }

    public void sendTo(ServerPlayer player) {
        AdHooks.getInstance().getConnection().sendToPlayer((Object)this, player);
    }

    public JumpBoostMsg create() {
        return new JumpBoostMsg();
    }

    public void handle(Level world, Player player) {
        double playerMotionY = player.m_20184_().f_82480_;
        double newMotionY = playerMotionY + (double)this.strength;
        double maxMotionY = this.maxStrengthFactor * this.strength;
        if (newMotionY > maxMotionY) {
            newMotionY = Math.max(playerMotionY, maxMotionY);
        }
        Vect3d newMotion = ForgeEntity.getMotion((Entity)player).withY(newMotionY);
        ForgeEntity.setMotion((Entity)player, (Vect3d)newMotion);
    }
}

